/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.console;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.fsp.cmdhelpers.FspQueryData;
import com.ibm.hsc.objmgr.console.OmConnListener;
import com.ibm.hsc.objmgr.sys.OmSysMgr;
import org.snia.wbem.cim.CIMException;

public class OmConnCreationThread
extends Thread {
    protected FspQueryData mCurQueryData;
    protected int mCurVport;
    protected FspQueryData mNextQueryData = null;
    protected OmConnListener mListener;
    protected boolean mStopped = false;

    public OmConnCreationThread(FspQueryData fspQueryData, int n, OmConnListener omConnListener) {
        this.mCurQueryData = fspQueryData;
        this.mCurVport = n;
        this.mListener = omConnListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = true;
        while (bl) {
            bl = false;
            try {
                this.newSystem();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CIMClientDaemonClassLogInfo);
            }
            OmConnCreationThread omConnCreationThread = this;
            synchronized (omConnCreationThread) {
                if (this.mNextQueryData == null) {
                    if (!this.mStopped) {
                        this.mStopped = true;
                        this.mListener.finishHandling(this.mCurVport);
                    }
                    break;
                }
                this.mCurQueryData = this.mNextQueryData;
                this.mNextQueryData = null;
                bl = true;
            }
        }
    }

    private void newSystem() throws CIMException, PIHscServerException {
        String string = this.mCurQueryData.getMtms();
        System.out.println("creating new fsp cec: " + string + " vport: " + this.mCurVport);
        int n = string.indexOf("*");
        if (n == -1) {
            System.out.println("Error: mtms format is type-model*serial");
            return;
        }
        System.out.println("before calling CecUpdate");
        try {
            byte[] byArray = new byte[4];
            HardwareServerMessage.intToBytes(this.mCurVport, byArray, 0);
            OmSysMgr.createSysMgr(this.mCurQueryData, byArray);
        }
        catch (Throwable throwable) {
            System.out.println("Error calling rebuild through OmCecMgr:updateCecAll() ");
            throwable.printStackTrace();
        }
    }

    public synchronized void addNewReq(FspQueryData fspQueryData) {
        this.mNextQueryData = fspQueryData;
        if (this.mNextQueryData == null) {
            this.mStopped = true;
        }
    }
}

